// src/config/redis.ts (atau src/lib/redis.ts sesuai struktur kamu)

import { createClient, RedisClientType } from 'redis';

const redisClient: RedisClientType = createClient({
    url: process.env.REDIS_URL,
});

redisClient.on('error', (err) => {
  console.error('Redis Client Error:', err);
});

(async () => {
  try {
    await redisClient.connect();
    console.log('Redis connected');
  } catch (err) {
    console.error('Redis connection failed:', err);
  }
})();

export default redisClient;
