'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    const roles = [
      {
        name: 'owner',
        slug: 'Owner',
      },
      {
        name: 'Support (Internal)',
        slug: 'support_internal',
      },
      {
        name: 'Support (Client)',
        slug: 'support_client',
      },
    ];

    // Avoid inserting duplicates
    for (const role of roles) {
      const [existing] = await queryInterface.sequelize.query(
        `SELECT 1 FROM "pik_master"."role_panel" WHERE slug = :slug LIMIT 1`,
        {
          replacements: { slug: role.slug },
          type: Sequelize.QueryTypes.SELECT,
        }
      );

      if (!existing) {
        await queryInterface.bulkInsert(
          { tableName: 'role_panel', schema: 'pik_master' },
          [
            {
              ...role,
              created_at: new Date(),
              updated_at: new Date(),
            },
          ]
        );
      }
    }
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete(
      { tableName: 'role_panel', schema: 'pik_master' },
      {
        slug: ['Owner', 'support_internal', 'support_client'],
      }
    );
  },
};
