'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    const schema = 'pik_master';
    const menus = [
      {
        id: 1,
        title: 'Home',
        icon: 'HomeIcon',
        page_name: 'side-menu-home',
        parent_id: null,
      },
      {
        id: 2,
        title: 'Statement Report',
        icon: 'FileTextIcon',
        page_name: 'side-menu-statement-report',
        parent_id: null,
      },
      {
        id: 3,
        title: 'Win Lose Report',
        icon: 'BarChart2Icon',
        page_name: 'side-menu-win-lose-report',
        parent_id: null,
      },
      {
        id: 4,
        title: 'Platform Report',
        icon: 'MonitorIcon',
        page_name: 'side-menu-platform-report',
        parent_id: null,
      },
      {
        id: 5,
        title: 'Game Report',
        icon: 'CodepenIcon',
        page_name: 'side-menu-game-report',
        parent_id: null,
      },
      {
        id: 6,
        title: 'Player Report',
        icon: 'UsersIcon',
        page_name: 'side-menu-player-report',
        parent_id: null,
      },
      {
        id: 7,
        title: 'Replay Record',
        icon: 'AirplayIcon',
        page_name: 'side-menu-replay-record',
        parent_id: null,
      },
      {
        id: 8,
        title: 'Player Report',
        icon: 'UsersIcon',
        page_name: 'side-menu-player-report',
        parent_id: 7, // submenu of Replay Record
      },
    ];

    await queryInterface.bulkInsert({ tableName: 'menu_panel', schema }, menus);
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete({ tableName: 'menu_panel', schema: 'pik_master' }, null, {});
  }
};
