'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    const schema = 'pik_master';

    const roleIds = [1, 2, 3];
    const menuIds = [1, 2, 3, 4, 5, 6, 7, 8];

    const allAccess = [];

    for (const role_id of roleIds) {
      for (const menu_id of menuIds) {
        allAccess.push({
          role_id,
          menu_id,
          created_at: new Date(),
          updated_at: new Date(),
        });
      }
    }

    await queryInterface.bulkInsert(
      { tableName: 'menu_role_panel', schema },
      allAccess
    );
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete(
      { tableName: 'menu_role_panel', schema: 'pik_master' },
      null,
      {}
    );
  }
};
