import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../config';

export interface AdminAttributes {
  username: string;
  email: string;
  password: string;
  client: string;
}

// Optional fields when creating a new admin (e.g., in `create`)
type AdminCreationAttributes = Optional<AdminAttributes, 'username' | 'email' | 'password' | 'client'>;

export interface AdminInstance
  extends Model<AdminAttributes, AdminCreationAttributes>,
    AdminAttributes {}

const Admin = sequelize.define<AdminInstance>(
  'admin',
  {
    username: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: true,
      validate: {
        isEmail: true,
      },
    },
    password: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client: {
      type: DataTypes.STRING,
      allowNull: true,
    },
  },
  {
    tableName: 'admin',
    schema: 'pik_master',
    timestamps: false,
    underscored: true,
  },
);

export default Admin;
