import { DataTypes, Model } from 'sequelize';
import sequelize from '../config';
import ReportTransactionDetail from './ReportTransactionDetail';

export interface GameLogAttributes {
  member_id: number;
  name: string;
  individual_id: number;
  gametype: string;
  app_id: string;
  id: number;
  coin_bet: number;
  coin_result: number;
  coin_before: number;
  coin_after: number;
  multiplier_result: number;
  create_date: Date;
  update_date: Date;
  ip_address: string;
  bo_formation_code?: string;
  bo_reward_box_multiplier?: string;
  bo_reward_multiplier?: number;
  bo_bounce_id?: number;
  pl_ball_type?: string;
  mo_position_before?: string;
  mo_position_after?: string;
  mo_plate_code_reward?: string;
  mo_dice_value?: number;
  mn_status?: string;
  mn_next_multiplier?: number;
  mn_bomb_value?: number;
  mn_current_streaks?: number;
  mn_opened_plate?: string;
  mn_bonus_item?: string;
  mn_bonus_item_slot?: number;
  mn_unopened_plate?: string;
  he_status?: string;
  he_opened_plate?: string;
  he_multiplier_1?: number;
  he_multiplier_2?: number;
  he_multiplier_3?: number;
  he_current_item_1?: number;
  he_current_item_2?: number;
  he_current_item_3?: number;
  he_result?: string;
  he_isjackpot?: boolean;
  he_unopened_plate?: string;
}

const GameLog = sequelize.define<Model<GameLogAttributes>>(
  'GameLog',
  {
    member_id: { type: DataTypes.INTEGER },
    name: { type: DataTypes.STRING },
    individual_id: { type: DataTypes.INTEGER },
    gametype: { type: DataTypes.TEXT },
    app_id: { type: DataTypes.STRING },
    id: { type: DataTypes.INTEGER, primaryKey: true },
    coin_bet: { type: DataTypes.DOUBLE },
    coin_result: { type: DataTypes.DOUBLE },
    coin_before: { type: DataTypes.DOUBLE },
    coin_after: { type: DataTypes.DOUBLE },
    multiplier_result: { type: DataTypes.DOUBLE },
    create_date: { type: DataTypes.DATE },
    update_date: { type: DataTypes.DATE },
    ip_address: { type: DataTypes.TEXT },
    bo_formation_code: { type: DataTypes.STRING },
    bo_reward_box_multiplier: { type: DataTypes.STRING },
    bo_reward_multiplier: { type: DataTypes.DOUBLE },
    bo_bounce_id: { type: DataTypes.INTEGER },
    pl_ball_type: { type: DataTypes.TEXT },
    mo_position_before: { type: DataTypes.TEXT },
    mo_position_after: { type: DataTypes.TEXT },
    mo_plate_code_reward: { type: DataTypes.TEXT },
    mo_dice_value: { type: DataTypes.INTEGER },
    mn_status: { type: DataTypes.TEXT },
    mn_next_multiplier: { type: DataTypes.DOUBLE },
    mn_bomb_value: { type: DataTypes.INTEGER },
    mn_current_streaks: { type: DataTypes.INTEGER },
    mn_opened_plate: { type: DataTypes.TEXT },
    mn_bonus_item: { type: DataTypes.TEXT },
    mn_bonus_item_slot: { type: DataTypes.INTEGER },
    mn_unopened_plate: { type: DataTypes.TEXT },
    he_status: { type: DataTypes.TEXT },
    he_opened_plate: { type: DataTypes.TEXT },
    he_multiplier_1: { type: DataTypes.DOUBLE },
    he_multiplier_2: { type: DataTypes.DOUBLE },
    he_multiplier_3: { type: DataTypes.DOUBLE },
    he_current_item_1: { type: DataTypes.DOUBLE },
    he_current_item_2: { type: DataTypes.DOUBLE },
    he_current_item_3: { type: DataTypes.DOUBLE },
    he_result: { type: DataTypes.TEXT },
    he_isjackpot: { type: DataTypes.BOOLEAN },
    he_unopened_plate: { type: DataTypes.TEXT },
  },
  {
    tableName: 'allgame_transaction',
    schema: 'pik_master',
    timestamps: false,
    underscored: true,
  }
);

GameLog.belongsTo(ReportTransactionDetail, {
  foreignKey: 'member_id',
  targetKey: 'member_id',
  as: 'client',
});

export default GameLog;