// db/models/Client.ts

import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../config';

export interface ClientAttributes {
  id: string;
  name: string;
  total_user?: number;
  partner_id: string;
  join_date?: Date;
  client_username?: string;
  client_password?: string;
  client_link_auth?: string;
  client_link_verify?: string;
  client_link_get_balance?: string;
  excluded_game?: string;
  client_secret?: string;
  shared?: number;
  seamless_support?: boolean;
}

// Optional saat create (misalnya pakai create())
type ClientCreationAttributes = Optional<ClientAttributes, 'total_user' | 'join_date' | 'client_username' | 'client_password' | 'client_link_auth' | 'client_link_verify' | 'client_link_get_balance' | 'excluded_game' | 'client_secret' | 'shared' | 'seamless_support'>;

export interface ClientInstance
  extends Model<ClientAttributes, ClientCreationAttributes>,
    ClientAttributes {}

const Client = sequelize.define<ClientInstance>(
  'client_master',
  {
    id: {
      type: DataTypes.STRING,
      allowNull: false,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    total_user: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
      allowNull: true,
    },
    partner_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    join_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
      allowNull: true,
    },
    client_username: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client_password: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client_link_auth: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client_link_verify: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client_link_get_balance: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    excluded_game: {
      type: DataTypes.STRING,
      defaultValue: '-',
      allowNull: true,
    },
    client_secret: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shared: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    seamless_support: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
      allowNull: true,
    },
  },
  {
    tableName: 'client_master',
    schema: 'pik_master',
    timestamps: false,
  }
);

export default Client;
