// db/models/Currency.ts

import {DataTypes} from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type CurrencyAttributes = {
  id?: number;
  status?: number;
  code: string;
  name: string;
  symbol: string;
  idr_rates?: number;
  usd_rates?: number;
  min_bet?: number;
  max_bet?: number;
  bet_category_1?: number;
  bet_category_2?: number;  
  bet_category_3?: number;
  bet_category_4?: number;
  decimal_digits?: number;
  last_conversion_check?: Date;
};

const Currency = sequelize.define(
  'currency_data',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    status: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    symbol: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    idr_rates: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    usd_rates: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    min_bet: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    max_bet: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    bet_category_1: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    bet_category_2: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    bet_category_3: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    bet_category_4: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    decimal_digits: {
      type: DataTypes.INTEGER,
      defaultValue: 2,
    },
    last_conversion_check: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'currency_data',
  },
);

export default Currency;
