// db/models/DomainList.ts

import {DataTypes} from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type DomainListAttributes = {
  id?: number;
  domain: string;
  client?: string;
  status?: boolean;
  last_update?: Date;
  created_at?: Date;
};

const DomainList = sequelize.define(
  'domain_list',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    domain: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    client: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    last_update: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'domain_list',
  },
);

export default DomainList;
