import {DataTypes} from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type GameListAttributes = {
  id?: number;
  name: string;
  game_url: string;
  game_type_id: string;
  type_description: string;
  technology: string;
  platform: string;
  demo_available?: boolean;
  aspect_ratio: string;
  created_date?: Date;
  updated_date?: Date;
  icon_url: string;
  status?: number;
  owner?: number;
  latest_version?: string;
  isMaintenance?: boolean;
};

const GameList = sequelize.define(
  'game_list',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    game_url: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    game_type_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    type_description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    technology: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    platform: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    demo_available: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
      allowNull: false,
    },
    aspect_ratio: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    created_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
      allowNull: true,
    },
    updated_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
      allowNull: true,
    },
    icon_url: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.INTEGER,
    },
    owner: {
      type: DataTypes.INTEGER,
    },
    latest_version: {
      type: DataTypes.STRING,
    },
    isMaintenance: {
      type: DataTypes.BOOLEAN,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'game_list',
  },
);

export default GameList;
