import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type LanguageDataAttributes = {
  id?: number;
  status?: number;
  code: string;
  name: string;
};

const LanguageData = sequelize.define(
  'language_data',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    status: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'language_data',
    modelName: 'language_data',
  }
);

export default LanguageData;