
import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type LoginHistoryAttributes = {
  id?: number;
  trace_id: string;
  player_id?: string;
  player_uname?: string;
  player_username?: string;
  player_client?: string;
  player_action?: string;
  player_action_transaction?: string;
  last_update?: Date;
  created_at?: Date;
};

const LoginHistory = sequelize.define(
  'login_history',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    trace_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    player_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_uname: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_username: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_client: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_action: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_action_transaction: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    last_update: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'login_history',
    modelName: 'login_history',
  }
);

export default LoginHistory;