import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type MasterIndividualBucketAttributes = {
  id?: number;
  member_id: number;
  start_coin: number;
  current_coin: number;
  number_given: number;
  coin_given: number;
  client: string;
  currency: string;
  create_date?: Date;
  update_date?: Date;
  wallet_profit?: number;
  total_withdraw?: number;
  total_deposit?: number;
};

const MasterIndividualBucket = sequelize.define(
  'master_individual_bucket',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    member_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    start_coin: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    current_coin: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    number_given: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    coin_given: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    client: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    create_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    update_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    wallet_profit: {
      type: DataTypes.FLOAT,
      allowNull: true,
      defaultValue: 0,
    },
    total_withdraw: {
      type: DataTypes.FLOAT,
      allowNull: true,
      defaultValue: 0,
    },
    total_deposit: {
      type: DataTypes.FLOAT,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'master_individual_bucket',
  }
);

export default MasterIndividualBucket;
