import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type MasterMemberAttributes = {
  id?: number;
  name: string;
  email?: string;
  phone?: string;
  is_banned?: boolean;
  language?: string;
  client_id?: string;
  client_player_id?: string;
  client_token?: string;
  config_seamless?: boolean;
  last_update?: Date;
  created_at?: Date;
};

const MasterMember = sequelize.define(
  'master_member',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: true,
      validate: {
        isEmail: true,
      },
    },
    phone: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    is_banned: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    language: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: 'id',
    },
    client_id: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: 'IN01',
    },
    client_player_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    client_token: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: '-',
    },
    config_seamless: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    last_update: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'master_member',
  }
);

export default MasterMember;