import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type MasterWalletTransactionAttributes = {
  ptx_id?: number;
  app_id: string;
  timestamp: number;
  currency: string;
  amount: number;
  tx_id: string;
  member_id: number;
  individual_id: number;
  create_date?: Date;
  update_date?: Date;
};

const MasterWalletTransaction = sequelize.define(
  'master_wallet_transaction',
  {
    ptx_id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    app_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    timestamp: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    amount: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    tx_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    member_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    individual_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    create_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    update_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    tableName: 'master_wallet_transaction',
    modelName: 'master_wallet_transaction',
  }
);

export default MasterWalletTransaction;
