import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../config';

export interface MenuPanelAttributes {
  id?: number;
  title: string;
  icon?: string;
  page_name?: string;
  parent_id?: number;
  created_at?: Date;
  updated_at?: Date;
}

// Optional attributes for creation
export interface MenuPanelCreationAttributes extends Optional<MenuPanelAttributes, 'id'> {}

const MenuPanel = sequelize.define<Model<MenuPanelAttributes, MenuPanelCreationAttributes>>(
  'MenuPanel',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    title: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    icon: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    page_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    parent_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    tableName: 'menu_panel',
    schema: 'pik_master',
    timestamps: false,
    underscored: true,
  }
);

export default MenuPanel;
