import { DataTypes, Model, Optional } from 'sequelize';
import MenuPanel from './MenuPanel';
import sequelize from '../config';

// Step 1: Define attributes for MenuRolePanel
export interface MenuRolePanelAttributes {
  id?: number;
  menu_id: number;
  role_id: number;
  created_at?: Date;
  updated_at?: Date;
}

// Step 2: Define creation attributes
export interface MenuRolePanelCreationAttributes
  extends Optional<MenuRolePanelAttributes, 'id' | 'created_at' | 'updated_at'> {}

// Step 3: Define the model class
class MenuRolePanel
  extends Model<MenuRolePanelAttributes, MenuRolePanelCreationAttributes>
  implements MenuRolePanelAttributes
{
  public id!: number;
  public menu_id!: number;
  public role_id!: number;
  public created_at?: Date;
  public updated_at?: Date;
}

// Step 4: Initialize the model
MenuRolePanel.init(
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    menu_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    role_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    sequelize,
    tableName: 'menu_role_panel',
    schema: 'pik_master',
    modelName: 'MenuRolePanel',
    timestamps: false,
    underscored: true,
  }
);


MenuRolePanel.belongsTo(MenuPanel, {
    foreignKey: 'menu_id',
    as: 'menu',
  });

export default MenuRolePanel;
