import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../config';

// 1. Attributes for reading (output)
export interface PartnerAttributes {
  id: number;
  name: string;
  join_date: Date;
}

// 2. Attributes for creating (input)
export interface PartnerCreationAttributes extends Optional<PartnerAttributes, 'id' | 'join_date'> {}

// 3. Model instance type
export interface PartnerInstance extends Model<PartnerAttributes, PartnerCreationAttributes>, PartnerAttributes {}

// 4. Define model
const Partner = sequelize.define<PartnerInstance>(
  'partner_master',
  {
    id: {
      type: DataTypes.BIGINT,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    join_date: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    tableName: 'partner_master',
    schema: 'pik_master',
    underscored: true,
    timestamps: false,
  },
);

export default Partner;
