// src/db/models/PartnerMaster.ts

import { Model, DataTypes, Optional } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export interface PartnerMasterAttributes {
  id: string;
  name: string;
  join_date?: Date;
}

export interface PartnerMasterCreationAttributes
  extends Optional<PartnerMasterAttributes, 'join_date'> {}

class PartnerMaster
  extends Model<PartnerMasterAttributes, PartnerMasterCreationAttributes>
  implements PartnerMasterAttributes
{
  public id!: string;
  public name!: string;
  public join_date!: Date;
}

PartnerMaster.init(
  {
    id: {
      type: DataTypes.STRING,
      allowNull: false,
      primaryKey: true,
      autoIncrement: false,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    join_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
      allowNull: true,
    },
  },
  {
    sequelize,
    modelName: 'partner_master',
    tableName: 'partner_master',
    schema: 'pik_master',
    timestamps: false,
  }
);

export default PartnerMaster;
