import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export type PopularGameAttributes = {
  id?: number;
  name: string;
  icon_url: string;
  game_url: string;
  game_type_id: string;
  type_description: string;
  technology: string;
  platform: string;
  demo_available?: boolean;
  aspect_ratio: string;
  created_date?: Date;
  updated_date?: Date;
};

const PopularGame = sequelize.define(
  'popular_game',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    icon_url: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    game_url: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    game_type_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    type_description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    technology: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    platform: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    demo_available: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
      allowNull: false,
    },
    aspect_ratio: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    created_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
      allowNull: true,
    },
    updated_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
      allowNull: true,
    },
  },
  {
    timestamps: false,
    schema: 'pik_master',
    modelName: 'popular_game',
    tableName: 'popular_game',
  }
);

export default PopularGame;
