import {DataTypes, Model} from 'sequelize';
import sequelize from '../config';

class WalletTransactionView extends Model {}

WalletTransactionView.init(
  {
    trandate: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    member_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    client_player_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    app_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    amount: {
      type: DataTypes.DOUBLE,
      allowNull: false,
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    player_action: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    tx_id: {
      type: DataTypes.STRING,
      allowNull: false,
      primaryKey: true, // diasumsikan tx_id unik, bisa jadi primary
    },
  },
  {
    sequelize,
    // modelName: 'WalletTransactionView',
    tableName: 'report_transferDetail',
    schema: 'pik_master',
    timestamps: false,
    freezeTableName: true,
  },
);

export default WalletTransactionView;
