import {Model, DataTypes} from 'sequelize';
import sequelize from '../../db/config';

const ReportTransactionDetail = sequelize.define(
  'ReportTransactionDetail',
  {
    game_title: {
        type: DataTypes.STRING,
        allowNull: true,
        field: 'game_title',
      },
      tran_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        field: 'tran_id',
      },
      partner_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true, // ini yang penting
        field: 'partner_id',
      },
    member_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true, // ini yang penting
      field: 'member_id',
    },
    client_player_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true, // ini yang penting
        field: 'client_player_id',
      },
    player_nickname: {
      type: DataTypes.STRING,
      allowNull: true,
      field: 'player_nickname',
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: true,
      field: 'currency',
    },
    coin_bet: {
      type: DataTypes.DOUBLE,
      allowNull: true,
      field: 'coin_bet',
    },
    coin_result: {
      type: DataTypes.DOUBLE,
      allowNull: true,
      field: 'coin_result',
    },
    winlose: {
      type: DataTypes.DOUBLE,
      allowNull: true,
      field: 'winlose',
    },
    transaction_date: {
      type: DataTypes.DATE,
      allowNull: true,
      field: 'transaction_date',
    },
    note_transaction: {
      type: DataTypes.TEXT,
      allowNull: true,
      field: 'note_transaction',
    },
    // tambahkan kolom lain sesuai dengan struktur tabel asli jika ada
  },
  {
    tableName: 'report_transactionDetail',
    schema: 'pik_master',
    timestamps: false,
    underscored: true,
    createdAt: false,
    updatedAt: false,
  },
);

export default ReportTransactionDetail;
