import {Model, DataTypes} from 'sequelize';
import sequelize from '../config';
import RolePanel from './RolePanel';
import Client from './Client';


interface RoleAppPanelAttributes {
    id: number;
    role_id: number;
    app_id: string;
  }
  
  class RoleAppPanel extends Model<RoleAppPanelAttributes> {
    public id!: number;
    public role_id!: number;
    public app_id!: string;
  
    // Tambahkan properti relasi
    public client?: typeof Client;
  }

RoleAppPanel.init(
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    role_id: DataTypes.INTEGER,
    app_id: DataTypes.INTEGER,
  },
  {
    sequelize,
    modelName: 'RoleAppPanel',
    tableName: 'role_app_panel',
    schema: 'pik_master',
    timestamps: true,
    underscored: true,
  },
);

RoleAppPanel.belongsTo(Client, {
    foreignKey: 'app_id',
    targetKey: 'id',
    as: 'client',
  });
  

export default RoleAppPanel;
