import { Model, DataTypes } from 'sequelize';
import sequelize from '../config'; 
import RoleAppPanel from './RoleAppPanel';

export type RolePanelAttributes = {
  id?: number;
  name?: string;
  slug?: string;
};

class RolePanel extends Model<RolePanelAttributes> implements RolePanelAttributes {
  id?: number;
  name?: string;
  slug?: string;
}


RolePanel.init(
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    slug: {
      type: DataTypes.STRING,
      allowNull: false,
    },
  },
  {
    sequelize,
    modelName: 'RolePanel',
    tableName: 'role_panel',
    schema: 'pik_master',
    timestamps: true,
    underscored: true,
  }
);

RolePanel.hasMany(RoleAppPanel, {
  foreignKey: 'role_id',
  as: 'apps', // 
});

export default RolePanel;
