import {Model, DataTypes, Optional} from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export interface SeamlessWalletAttributes {
  id: number;
  order_id: string;
  timestamp: number;
  app_id: string;
  transaction_type: string;
  status: string;
  currency: string;
  amount: number;
  bet: number;
  member_id: number;
  individual_id: number;
  games_id: number;
  create_date?: Date;
  update_date?: Date;
}

export interface SeamlessWalletCreationAttributes
  extends Optional<
    SeamlessWalletAttributes,
    'id' | 'create_date' | 'update_date'
  > {}

class SeamlessWallet
  extends Model<SeamlessWalletAttributes, SeamlessWalletCreationAttributes>
  implements SeamlessWalletAttributes
{
  public id!: number;
  public order_id!: string;
  public timestamp!: number;
  public app_id!: string;
  public transaction_type!: string;
  public status!: string;
  public currency!: string;
  public amount!: number;
  public bet!: number;
  public member_id!: number;
  public individual_id!: number;
  public games_id!: number;
  public create_date!: Date;
  public update_date!: Date;
}

SeamlessWallet.init(
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    order_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    timestamp: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    app_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    transaction_type: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    amount: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    bet: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    member_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    individual_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    games_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    create_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    update_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    sequelize,
    modelName: 'seamless_wallet',
    tableName: 'seamless_wallet',
    schema: 'pik_master',
    timestamps: false,
  },
);

export default SeamlessWallet;
