import { Model, DataTypes, Optional } from 'sequelize';
import sequelize from '../config'; // pastikan pointing ke instance sequelize

export interface ServiceResponseAttributes {
  id: number;
  trace_id: string;
  player_id?: string | null;
  player_uname?: string | null;
  player_username?: string | null;
  player_client?: string | null;
  transaction_id?: string | null;
  merchant_transaction_id?: string | null;
  transaction_status?: string | null;
  failed_reason?: string | null;
  last_update?: Date;
  created_at?: Date;
}

export interface ServiceResponseCreationAttributes
  extends Optional<ServiceResponseAttributes, 'id' | 'last_update' | 'created_at'> {}

class ServiceResponse
  extends Model<ServiceResponseAttributes, ServiceResponseCreationAttributes>
  implements ServiceResponseAttributes
{
  public id!: number;
  public trace_id!: string;
  public player_id!: string | null;
  public player_uname!: string | null;
  public player_username!: string | null;
  public player_client!: string | null;
  public transaction_id!: string | null;
  public merchant_transaction_id!: string | null;
  public transaction_status!: string | null;
  public failed_reason!: string | null;
  public last_update!: Date;
  public created_at!: Date;
}

ServiceResponse.init(
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    trace_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    player_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_uname: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_username: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    player_client: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    transaction_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    merchant_transaction_id: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    transaction_status: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    failed_reason: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    last_update: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    sequelize,
    modelName: 'service_response',
    tableName: 'service_response',
    schema: 'pik_master',
    timestamps: false,
  }
);

export default ServiceResponse;
