import { DataTypes } from 'sequelize';
import sequelize from '../config';
import RolePanel from './RolePanel'; 

export type UserPanelAttributes = {
  id?: number;
  name?: string;
  username?: string;
  password?: string;
  role_id?: number;
};

const UserPanel = sequelize.define(
  'user_panel',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    username: {
      type: DataTypes.STRING,
      allowNull: false,
      unique: true,
    },
    password: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    role_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
  },
  {
    tableName: 'user_panel',
    schema: 'pik_master',
    underscored: true,
    timestamps: true,
  }
);

// UserPanel.belongsTo(RolePanel, { foreignKey: 'role_id', as: 'role' });
UserPanel.belongsTo(RolePanel, {
  foreignKey: 'role_id',
  as: 'role',
});


export default UserPanel;
