import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface TransactionBounceAttributes {
  id: number;
  individual_id: number;
  collection_id: number;
  bounce_id: number;
  coin_result: number;
  coin_bet: number;
  coin_after: number;
  coin_before: number;
  cycle: number;
  multiplier_result: number;
  formation_code: string;
  reward_box_num: string;
  reward_box_multiplier: string;
  reward_multiplier: number;
  ip: string;
  create_date: Date;
  update_date: Date;
}

type TransactionBounceCreationAttributes = Optional<
  TransactionBounceAttributes,
  | 'id'
  | 'coin_result'
  | 'formation_code'
  | 'reward_box_num'
  | 'reward_box_multiplier'
  | 'reward_multiplier'
  | 'ip'
  | 'create_date'
  | 'update_date'
>;

export interface TransactionBounceInstance
  extends Model<TransactionBounceAttributes, TransactionBounceCreationAttributes>,
    TransactionBounceAttributes {}

const TransactionBounce = sequelize.define<TransactionBounceInstance>(
  'transaction',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    individual_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    collection_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    bounce_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    coin_result: {
      type: DataTypes.FLOAT,
      allowNull: true,
      defaultValue: 0,
    },
    coin_bet: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    coin_after: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    coin_before: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    cycle: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    multiplier_result: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    formation_code: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: '0',
    },
    reward_box_num: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: '0',
    },
    reward_box_multiplier: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: '0',
    },
    reward_multiplier: {
      type: DataTypes.FLOAT,
      allowNull: true,
      defaultValue: 0,
    },
    ip: {
      type: DataTypes.STRING,
      defaultValue: '0.0.0.0',
    },
    create_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    update_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    modelName: 'transaction',
    tableName: 'transaction',
    schema: 'pik_bouncy1',
    timestamps: false,
  }
);

export default TransactionBounce;
