import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface CollectionBucketBounceAztecAttributes {
  id: number;
  rtp: number;
  current: number;
  total_max: number;
  total_cycle: number;
  total_shared: number;
  total_bet: number;
  total_result: number;
  current_rtp: number;
  client_id: string;
  last_reset: Date;
  is_jackpot: boolean;
  currency: string;
  create_date: Date;
  update_date: Date;
}

type CollectionBucketBounceAztecCreationAttributes = Optional<
  CollectionBucketBounceAztecAttributes,
  | 'id'
  | 'current'
  | 'total_max'
  | 'total_cycle'
  | 'total_shared'
  | 'total_bet'
  | 'total_result'
  | 'current_rtp'
  | 'client_id'
  | 'last_reset'
  | 'is_jackpot'
  | 'currency'
  | 'create_date'
  | 'update_date'
>;

export interface CollectionBucketBounceAztecInstance
  extends Model<CollectionBucketBounceAztecAttributes, CollectionBucketBounceAztecCreationAttributes>,
    CollectionBucketBounceAztecAttributes {}

const CollectionBucketBounceAztec = sequelize.define<CollectionBucketBounceAztecInstance>(
  'collection_bucket',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    rtp: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    current: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    total_max: {
      type: DataTypes.FLOAT,
      defaultValue: 1000000,
    },
    total_cycle: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    total_shared: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    total_bet: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    total_result: {
      type: DataTypes.FLOAT,
      defaultValue: 0,
    },
    current_rtp: {
      type: DataTypes.FLOAT,
      defaultValue: 95,
    },
    client_id: {
      type: DataTypes.STRING,
      defaultValue: 'IN01',
    },
    last_reset: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    is_jackpot: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    currency: {
      type: DataTypes.STRING,
      defaultValue: 'idr',
    },
    create_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    update_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    tableName: 'collection_bucket',
    modelName: 'collection_bucket',
    schema: 'pik_bouncy2',
    timestamps: false,
    underscored: true,
  }
);

export default CollectionBucketBounceAztec;
