import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface CollectionBucketCrashAttributes {
  id: number;
  total_max: number;
  total_cycle: number;
  total_shared: number;
  current: number;
  rtp: number;
  is_loss: number;
  last_player: number | null;
  total_bet: number | null;
  total_result: number | null;
  client_id: string | null;
  update_date: Date;
  create_date: Date;
  last_reset: Date;
  is_jackpot: boolean | null;
  currency: string;
}

type CollectionBucketCrashCreationAttributes = Optional<
  CollectionBucketCrashAttributes,
  | 'id'
  | 'last_player'
  | 'total_bet'
  | 'total_result'
  | 'client_id'
  | 'update_date'
  | 'create_date'
  | 'last_reset'
  | 'is_jackpot'
  | 'currency'
>;

export interface CollectionBucketCrashInstance
  extends Model<CollectionBucketCrashAttributes, CollectionBucketCrashCreationAttributes>,
    CollectionBucketCrashAttributes {}

const CollectionBucketCrash = sequelize.define<CollectionBucketCrashInstance>(
  'collection_bucket',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    total_max: { type: DataTypes.FLOAT, allowNull: false },
    total_cycle: { type: DataTypes.INTEGER, allowNull: false },
    total_shared: { type: DataTypes.FLOAT, allowNull: false },
    current: { type: DataTypes.FLOAT, allowNull: false },
    rtp: { type: DataTypes.FLOAT, allowNull: false },
    is_loss: { type: DataTypes.FLOAT, allowNull: false },
    last_player: { type: DataTypes.INTEGER, allowNull: true },
    total_bet: { type: DataTypes.FLOAT, allowNull: true },
    total_result: { type: DataTypes.FLOAT, allowNull: true },
    client_id: { type: DataTypes.STRING, allowNull: true },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    last_reset: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    is_jackpot: { type: DataTypes.BOOLEAN, allowNull: true },
    currency: { type: DataTypes.STRING, defaultValue: 'idr' },
  },
  {
    modelName: 'collection_bucket',
    tableName: 'collection_bucket',
    schema: 'pik_crash1',
    timestamps: false,
    underscored: true,
  }
);

export default CollectionBucketCrash;
