import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface TransactionCrashAttributes {
  id: number;
  individual_id: number;
  collection_id: number;
  crash_id: number;
  cycle: number;
  coin_before: number;
  coin_after: number;
  coin_bet: number;
  coin_result: number;
  auto_50: string;
  auto_100: string;
  result_50: string | null;
  result_100: string | null;
  multiply_50: string | null;
  multiply_100: string | null;
  is_crash: string | null;
  status: string | null;
  update_date: Date;
  create_date: Date;
  ip_address: string;
}

type TransactionCrashCreationAttributes = Optional<
  TransactionCrashAttributes,
  | 'id'
  | 'result_50'
  | 'result_100'
  | 'multiply_50'
  | 'multiply_100'
  | 'is_crash'
  | 'status'
  | 'update_date'
  | 'create_date'
  | 'ip_address'
>;

export interface TransactionCrashInstance
  extends Model<TransactionCrashAttributes, TransactionCrashCreationAttributes>,
    TransactionCrashAttributes {}

const TransactionCrash = sequelize.define<TransactionCrashInstance>(
  'transaction',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    individual_id: { type: DataTypes.INTEGER, allowNull: false },
    collection_id: { type: DataTypes.INTEGER, allowNull: false },
    crash_id: { type: DataTypes.INTEGER, allowNull: false },
    cycle: { type: DataTypes.INTEGER, allowNull: false },
    coin_before: { type: DataTypes.FLOAT, allowNull: false },
    coin_after: { type: DataTypes.FLOAT, allowNull: false },
    coin_bet: { type: DataTypes.FLOAT, allowNull: false },
    coin_result: { type: DataTypes.FLOAT, allowNull: false },
    auto_50: { type: DataTypes.STRING, allowNull: false },
    auto_100: { type: DataTypes.STRING, allowNull: false },
    result_50: { type: DataTypes.STRING, allowNull: true },
    result_100: { type: DataTypes.STRING, allowNull: true },
    multiply_50: { type: DataTypes.STRING, allowNull: true },
    multiply_100: { type: DataTypes.STRING, allowNull: true },
    is_crash: { type: DataTypes.STRING, allowNull: true },
    status: { type: DataTypes.STRING, allowNull: true },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    ip_address: { type: DataTypes.STRING, allowNull: true, defaultValue: '0.0.0.0' },
  },
  {
    modelName: 'transaction',
    tableName: 'transaction',
    schema: 'pik_crash1',
    timestamps: false,
    underscored: true,
  }
);

export default TransactionCrash;
