import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface TransactionHeistAttributes {
  id: number;
  individual_id: number;
  collection_id: number;
  coin_result: number | string;
  coin_bet: number;
  coin_after: number;
  coin_before: number;
  cycle: number;
  status: string;
  opened_plate: string;
  multiplier_1: number;
  multiplier_2: number;
  multiplier_3: number;
  base_multiplier_1: number;
  base_multiplier_2: number;
  base_multiplier_3: number;
  multiplier_grant_1: string;
  multiplier_grant_2: string;
  multiplier_grant_3: string;
  current_item_1: number;
  current_item_2: number;
  current_item_3: number;
  item_slot_1: number;
  item_slot_2: number;
  item_slot_3: number;
  multiplier_slot: number;
  result: string;
  result_multiplier: string;
  is_jackpot: boolean;
  create_date: Date;
  update_date: Date;
  ip_address: string;
  unopened_plate: string;
}

type TransactionHeistCreationAttributes = Optional<
  TransactionHeistAttributes,
  | 'id'
  | 'coin_result'
  | 'status'
  | 'opened_plate'
  | 'multiplier_1'
  | 'multiplier_2'
  | 'multiplier_3'
  | 'base_multiplier_1'
  | 'base_multiplier_2'
  | 'base_multiplier_3'
  | 'multiplier_grant_1'
  | 'multiplier_grant_2'
  | 'multiplier_grant_3'
  | 'current_item_1'
  | 'current_item_2'
  | 'current_item_3'
  | 'item_slot_1'
  | 'item_slot_2'
  | 'item_slot_3'
  | 'multiplier_slot'
  | 'result'
  | 'result_multiplier'
  | 'is_jackpot'
  | 'create_date'
  | 'update_date'
  | 'ip_address'
  | 'unopened_plate'
>;

export interface TransactionHeistInstance
  extends Model<TransactionHeistAttributes, TransactionHeistCreationAttributes>,
    TransactionHeistAttributes {}

const TransactionHeist = sequelize.define<TransactionHeistInstance>(
  'transaction',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    individual_id: { type: DataTypes.INTEGER, allowNull: false },
    collection_id: { type: DataTypes.INTEGER, allowNull: false },
    coin_result: { type: DataTypes.FLOAT, allowNull: true, defaultValue: '-' },
    coin_bet: { type: DataTypes.FLOAT, allowNull: false },
    coin_after: { type: DataTypes.FLOAT, allowNull: false },
    coin_before: { type: DataTypes.FLOAT, allowNull: false },
    cycle: { type: DataTypes.INTEGER, allowNull: false },
    status: { type: DataTypes.STRING, defaultValue: 'ONGOING' },
    opened_plate: { type: DataTypes.STRING, defaultValue: '-' },
    multiplier_1: { type: DataTypes.FLOAT, defaultValue: 0 },
    multiplier_2: { type: DataTypes.FLOAT, defaultValue: 0 },
    multiplier_3: { type: DataTypes.FLOAT, defaultValue: 0 },
    base_multiplier_1: { type: DataTypes.FLOAT, defaultValue: 0 },
    base_multiplier_2: { type: DataTypes.FLOAT, defaultValue: 0 },
    base_multiplier_3: { type: DataTypes.FLOAT, defaultValue: 0 },
    multiplier_grant_1: { type: DataTypes.STRING, defaultValue: '0' },
    multiplier_grant_2: { type: DataTypes.STRING, defaultValue: '0' },
    multiplier_grant_3: { type: DataTypes.STRING, defaultValue: '0' },
    current_item_1: { type: DataTypes.FLOAT, defaultValue: 0 },
    current_item_2: { type: DataTypes.FLOAT, defaultValue: 0 },
    current_item_3: { type: DataTypes.FLOAT, defaultValue: 0 },
    item_slot_1: { type: DataTypes.FLOAT, defaultValue: 0 },
    item_slot_2: { type: DataTypes.FLOAT, defaultValue: 0 },
    item_slot_3: { type: DataTypes.FLOAT, defaultValue: 0 },
    multiplier_slot: { type: DataTypes.FLOAT, defaultValue: 0 },
    result: { type: DataTypes.STRING, defaultValue: '-' },
    result_multiplier: { type: DataTypes.STRING, defaultValue: '-' },
    is_jackpot: { type: DataTypes.BOOLEAN, defaultValue: false },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    ip_address: { type: DataTypes.STRING, allowNull: true, defaultValue: '0.0.0.0' },
    unopened_plate: { type: DataTypes.STRING, defaultValue: '-' },
  },
  {
    modelName: 'transaction',
    tableName: 'transaction',
    schema: 'pik_heist1',
    timestamps: false,
    underscored: true,
  }
);

export default TransactionHeist;
