import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface CollectionBucketMinesAttributes {
  id: number;
  rtp: number;
  current: number;
  total_max: number;
  total_cycle: number;
  total_shared: number;
  total_bet: number;
  total_result: number;
  current_rtp: number;
  client_id: string;
  last_reset: Date;
  create_date: Date;
  update_date: Date;
  currency: string;
}

type CollectionBucketMinesCreationAttributes = Optional<
  CollectionBucketMinesAttributes,
  | 'id'
  | 'current'
  | 'total_max'
  | 'total_cycle'
  | 'total_shared'
  | 'total_bet'
  | 'total_result'
  | 'current_rtp'
  | 'client_id'
  | 'last_reset'
  | 'create_date'
  | 'update_date'
  | 'currency'
>;

export interface CollectionBucketMinesInstance
  extends Model<CollectionBucketMinesAttributes, CollectionBucketMinesCreationAttributes>,
    CollectionBucketMinesAttributes {}

const CollectionBucketMines = sequelize.define<CollectionBucketMinesInstance>(
  'collection_bucket',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    rtp: { type: DataTypes.FLOAT, allowNull: false },
    current: { type: DataTypes.FLOAT, defaultValue: 0 },
    total_max: { type: DataTypes.FLOAT, defaultValue: 1000000 },
    total_cycle: { type: DataTypes.INTEGER, defaultValue: 0 },
    total_shared: { type: DataTypes.FLOAT, defaultValue: 0 },
    total_bet: { type: DataTypes.FLOAT, defaultValue: 0 },
    total_result: { type: DataTypes.FLOAT, defaultValue: 0 },
    current_rtp: { type: DataTypes.FLOAT, defaultValue: 95 },
    client_id: { type: DataTypes.STRING, defaultValue: 'IN01' },
    last_reset: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    currency: { type: DataTypes.STRING, defaultValue: 'idr' },
  },
  {
    tableName: 'collection_bucket',
    modelName: 'collection_bucket',
    schema: 'pik_mines1',
    timestamps: false,
    underscored: true,
  }
);

export default CollectionBucketMines;
