import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

export interface TransactionDiggerMinesAttributes {
  id: number;
  individual_id: number;
  collection_id: number;
  coin_result: number | null;
  coin_bet: number;
  coin_after: number;
  coin_before: number;
  cycle: number;
  status: string;
  multiplier: number | null;
  next_multiplier: number | null;
  base_increment: number;
  bomb_value: number;
  current_streaks: number;
  create_date: Date;
  update_date: Date;
  opened_plate: string;
  unopened_plate: string;
  ip_address: string | null;
}

type TransactionDiggerMinesCreationAttributes = Optional<
  TransactionDiggerMinesAttributes,
  | 'id'
  | 'coin_result'
  | 'multiplier'
  | 'next_multiplier'
  | 'status'
  | 'create_date'
  | 'update_date'
  | 'opened_plate'
  | 'unopened_plate'
  | 'ip_address'
>;

export interface TransactionDiggerMinesInstance
  extends Model<TransactionDiggerMinesAttributes, TransactionDiggerMinesCreationAttributes>,
    TransactionDiggerMinesAttributes {}

const TransactionDiggerMines = sequelize.define<TransactionDiggerMinesInstance>(
  'transaction',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    individual_id: { type: DataTypes.INTEGER, allowNull: false },
    collection_id: { type: DataTypes.INTEGER, allowNull: false },
    coin_result: { type: DataTypes.FLOAT, allowNull: true, defaultValue: 0 },
    coin_bet: { type: DataTypes.FLOAT, allowNull: false },
    coin_after: { type: DataTypes.FLOAT, allowNull: false },
    coin_before: { type: DataTypes.FLOAT, allowNull: false },
    cycle: { type: DataTypes.INTEGER, allowNull: false },
    status: { type: DataTypes.STRING, defaultValue: 'ONGOING' },
    multiplier: { type: DataTypes.FLOAT, allowNull: true, defaultValue: 0 },
    next_multiplier: { type: DataTypes.FLOAT, allowNull: true, defaultValue: 0 },
    base_increment: { type: DataTypes.FLOAT, allowNull: false },
    bomb_value: { type: DataTypes.INTEGER, allowNull: false },
    current_streaks: { type: DataTypes.INTEGER, allowNull: false },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    opened_plate: { type: DataTypes.STRING, defaultValue: '-' },
    unopened_plate: { type: DataTypes.STRING, defaultValue: '-' },
    ip_address: { type: DataTypes.STRING, allowNull: true, defaultValue: '0.0.0.0' },
  },
  {
    tableName: 'transaction',
    modelName: 'transaction',
    schema: 'pik_mines2',
    timestamps: false,
    underscored: true,
  }
);

export default TransactionDiggerMines;
