import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

interface CollectionBucketSnakeMonopolyAttributes {
  id: number;
  rtp: number;
  current?: number;
  total_max?: number;
  total_cycle?: number;
  total_shared?: number;
  total_bet?: number;
  total_result?: number;
  current_rtp?: number;
  is_jackpot?: boolean;
  client_id?: string;
  last_reset?: Date;
  create_date?: Date;
  update_date?: Date;
  currency?: string;
}

interface CollectionBucketSnakeMonopolyCreationAttributes
  extends Optional<CollectionBucketSnakeMonopolyAttributes, 'id' | 'current' | 'total_max' | 'total_cycle' | 'total_shared' | 'total_bet' | 'total_result' | 'current_rtp' | 'is_jackpot' | 'client_id' | 'last_reset' | 'create_date' | 'update_date' | 'currency'> {}

export interface CollectionBucketSnakeMonopolyInstance
  extends Model<CollectionBucketSnakeMonopolyAttributes, CollectionBucketSnakeMonopolyCreationAttributes>,
    CollectionBucketSnakeMonopolyAttributes {}

const CollectionBucketSnakeMonopoly = sequelize.define<CollectionBucketSnakeMonopolyInstance>(
  'collection_bucket',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    rtp: { type: DataTypes.FLOAT, allowNull: false },
    current: { type: DataTypes.FLOAT, defaultValue: 0 },
    total_max: { type: DataTypes.FLOAT, defaultValue: 1000000 },
    total_cycle: { type: DataTypes.INTEGER, defaultValue: 0 },
    total_shared: { type: DataTypes.FLOAT, defaultValue: 0 },
    total_bet: { type: DataTypes.FLOAT, defaultValue: 0 },
    total_result: { type: DataTypes.FLOAT, defaultValue: 0 },
    current_rtp: { type: DataTypes.FLOAT, defaultValue: 95 },
    is_jackpot: { type: DataTypes.BOOLEAN, defaultValue: false },
    client_id: { type: DataTypes.STRING, defaultValue: 'IN01' },
    last_reset: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    currency: { type: DataTypes.STRING, defaultValue: 'idr' },
  },
  {
    schema: 'pik_monopoly2',
    tableName: 'collection_bucket',
    modelName: 'collection_bucket',
    timestamps: false,
  }
);

export default CollectionBucketSnakeMonopoly;
