import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

interface TransactionSnakeMonopolyAttributes {
  id: number;
  individual_id: number;
  collection_id: number;
  coin_result?: number | null;
  coin_bet: number;
  coin_after: number;
  coin_before: number;
  cycle: number;
  player_position_before: string;
  player_position_after: string;
  plate_code_reward: string;
  dice_value: number;
  multiplier: number;
  create_date?: Date;
  update_date?: Date;
  ip_address?: string;
}

interface TransactionSnakeMonopolyCreationAttributes
  extends Optional<TransactionSnakeMonopolyAttributes, 'id' | 'coin_result' | 'create_date' | 'update_date' | 'ip_address'> {}

export interface TransactionSnakeMonopolyInstance
  extends Model<TransactionSnakeMonopolyAttributes, TransactionSnakeMonopolyCreationAttributes>,
    TransactionSnakeMonopolyAttributes {}

const TransactionSnakeMonopoly = sequelize.define<TransactionSnakeMonopolyInstance>(
  'transaction',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    individual_id: { type: DataTypes.INTEGER, allowNull: false },
    collection_id: { type: DataTypes.INTEGER, allowNull: false },
    coin_result: { type: DataTypes.FLOAT, allowNull: true },
    coin_bet: { type: DataTypes.FLOAT, allowNull: false },
    coin_after: { type: DataTypes.FLOAT, allowNull: false },
    coin_before: { type: DataTypes.FLOAT, allowNull: false },
    cycle: { type: DataTypes.INTEGER, allowNull: false },
    player_position_before: { type: DataTypes.STRING, allowNull: false },
    player_position_after: { type: DataTypes.STRING, allowNull: false },
    plate_code_reward: { type: DataTypes.STRING, allowNull: false },
    dice_value: { type: DataTypes.INTEGER, allowNull: false },
    multiplier: { type: DataTypes.FLOAT, allowNull: false },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    ip_address: { type: DataTypes.STRING, allowNull: true, defaultValue: '0.0.0.0' },
  },
  {
    schema: 'pik_monopoly2',
    tableName: 'transaction',
    modelName: 'transaction',
    timestamps: false,
  }
);

export default TransactionSnakeMonopoly;
