import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

interface CollectionBucketPlinkoAttributes {
  total_max: number;
  current: number;
  total_shared: number;
  total_cycle: number;
  rtp: number;
  current_gap: number;
  total_return: number;
  total_bet: number;
  client_id: string;
  create_date?: Date;
  update_date?: Date;
  currency?: string;
}

interface CollectionBucketPlinkoCreationAttributes
  extends Optional<CollectionBucketPlinkoAttributes, 'create_date' | 'update_date' | 'currency'> {}

export interface CollectionBucketPlinkoInstance
  extends Model<CollectionBucketPlinkoAttributes, CollectionBucketPlinkoCreationAttributes>,
    CollectionBucketPlinkoAttributes {}

const CollectionBucketPlinko = sequelize.define<CollectionBucketPlinkoInstance>(
  'collection_bucket',
  {
    total_max: { type: DataTypes.FLOAT, allowNull: false },
    current: { type: DataTypes.FLOAT, allowNull: false },
    total_shared: { type: DataTypes.FLOAT, allowNull: false },
    total_cycle: { type: DataTypes.INTEGER, allowNull: false },
    rtp: { type: DataTypes.FLOAT, allowNull: false },
    current_gap: { type: DataTypes.FLOAT, allowNull: false },
    total_return: { type: DataTypes.FLOAT, allowNull: false },
    total_bet: { type: DataTypes.FLOAT, allowNull: false },
    client_id: { type: DataTypes.STRING, allowNull: false },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    currency: { type: DataTypes.STRING, defaultValue: 'idr' },
  },
  {
    schema: 'pik_splinko1',
    tableName: 'collection_bucket',
    modelName: 'collection_bucket',
    timestamps: false,
  }
);

export default CollectionBucketPlinko;
