import { DataTypes, Model, Optional } from 'sequelize';
import sequelize from '../../../config';

interface TransactionLiongPlinkoAttributes {
  id: number;
  individual_id: number;
  coin_result: number;
  coin_bet: number;
  coin_after: number;
  coin_before: number;
  collection_id: number;
  cycle: number;
  type: string;
  is_jackpot: boolean;
  multiplier: string;
  current_bucket: number;
  total_shared: number;
  create_date?: Date;
  update_date?: Date;
  ip_address?: string;
}

interface TransactionLiongPlinkoCreationAttributes
  extends Optional<TransactionLiongPlinkoAttributes, 'id' | 'create_date' | 'update_date' | 'ip_address'> {}

export interface TransactionLiongPlinkoInstance
  extends Model<TransactionLiongPlinkoAttributes, TransactionLiongPlinkoCreationAttributes>,
    TransactionLiongPlinkoAttributes {}

const TransactionLiongPlinko = sequelize.define<TransactionLiongPlinkoInstance>(
  'transaction',
  {
    id: { type: DataTypes.INTEGER, autoIncrement: true, primaryKey: true },
    individual_id: { type: DataTypes.INTEGER, allowNull: false },
    coin_result: { type: DataTypes.FLOAT, allowNull: false },
    coin_bet: { type: DataTypes.FLOAT, allowNull: false },
    coin_after: { type: DataTypes.FLOAT, allowNull: false },
    coin_before: { type: DataTypes.FLOAT, allowNull: false },
    collection_id: { type: DataTypes.INTEGER, allowNull: false },
    cycle: { type: DataTypes.INTEGER, allowNull: false },
    type: { type: DataTypes.STRING, allowNull: false },
    is_jackpot: { type: DataTypes.BOOLEAN, allowNull: false },
    multiplier: { type: DataTypes.STRING, allowNull: false },
    current_bucket: { type: DataTypes.FLOAT, allowNull: false },
    total_shared: { type: DataTypes.FLOAT, allowNull: false },
    create_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    update_date: { type: DataTypes.DATE, defaultValue: DataTypes.NOW },
    ip_address: { type: DataTypes.STRING, allowNull: true, defaultValue: '0.0.0.0' },
  },
  {
    schema: 'pik_splinko2',
    tableName: 'transaction',
    modelName: 'transaction',
    timestamps: false,
  }
);

export default TransactionLiongPlinko;
