import { DataTypes } from 'sequelize';
import sequelize from '../config'; // pointing ke instance sequelize

export type MasterTransactionTestAttributes = {
  id?: number;
  order_id: string;
  individu_id: number;
  coin_result: number;
  coin_bet: number;
  coin_after: number;
  coin_before: number;
  status: number;
  create_date?: Date;
  update_date?: Date;
};

const MasterTransactionTest = sequelize.define(
  'master_transaction_test',
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    order_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    individu_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    coin_result: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    coin_bet: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    coin_after: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    coin_before: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    status: {
      type: DataTypes.FLOAT,
      allowNull: false,
    },
    create_date: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    update_date: {
      type: DataTypes.DATE,
      allowNull: false,
    },
  },
  {
    schema: 'pik_master',
    tableName: 'master_transaction_test',
    modelName: 'master_transaction_test',
    timestamps: true,
    createdAt: 'create_date',
    updatedAt: 'update_date',
  }
);

export default MasterTransactionTest;