import { getRoleAppsRpo } from '../role-app-panel/roleAppPanel.repository';
import {
  getAllGameTransactionsRepository,
  getGameTransactionByIdRepository,
} from './allGameTransaction.repository';

/**
 * Get all game transactions with optional pagination and search
 */
export const getAllGameTransactionsService = async (
  page: number = 1,
  limit: number = 10,
  pagination: boolean = true,
  roleId: number,
  playerName?: string,
  filters?: {
    startTime?: Date;
    endTime?: Date;
    playerId?: string;
    gameTitle?: string;
  },
) => {
  try {

    const [firstApp] = await getRoleAppsRpo(roleId);
    const appId = firstApp?.app_id;
    console.log('dataByRole', appId);

    if (!appId) {
      throw new Error('App ID not found for the given role.');
    }


    const data = await getAllGameTransactionsRepository(
      appId,
      page,
      limit,
      pagination,
      playerName,
      filters,
    );
    return data;
  } catch (error) {
    throw error;
  }
};

/**
 * Get a single game transaction by ID
 */
export const getGameTransactionByIdService = async (id: number) => {
  try {
    return await getGameTransactionByIdRepository(id);
  } catch (error) {
    throw error;
  }
};
