import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {loginSchema, registerSchema} from './authPanel.validation';
import {verifyPassword, generateToken} from '../../helpers/auth';
import { findByUsername } from '../users/user.repository';
import {createUserSvc} from '../users/user.service';
import HttpClient from '../../helpers/http-client';
import logger from '../../helpers/logger';

// const apiPlayerClient = new HttpClient(process.env.SERVICE_PLAYER);

export const loginSvc = async (data: any) => {
  // Validasi input
  const validation = loginSchema.validate(data, {allowUnknown: true});
  if (validation.error) {
    throw new CustomException(
      EXCEPTION_MESSAGE.MISSING_REQUIRED_DATA,
      validation.error,
    );
  }

  const {username, password} = validation.value;

  // Cari user di database
  const user = await findByUsername(username);

  if (!user) {
    throw new CustomException(EXCEPTION_MESSAGE.USER_NOT_FOUND);
  }

  // Verifikasi password
  const userData = user.toJSON();
  const isPasswordValid = await verifyPassword(password, userData.password);
  if (!isPasswordValid) {
    throw new CustomException(EXCEPTION_MESSAGE.NOT_AUTHORIZED);
  }

  // Generate JWT token
  const token = generateToken(user);

  return {token};
};

export const registerSvc = async (data: any) => {
  // // Validasi input
  const validation = registerSchema.validate(data, {allowUnknown: true});
  if (validation.error) {
    throw new CustomException(
      EXCEPTION_MESSAGE.MISSING_REQUIRED_DATA,
      validation.error,
    );
  }

  // // Cek apakah username sudah digunakan
  const existingUser = await findByUsername(validation.value.userName);
  if (existingUser) {
    throw new CustomException(EXCEPTION_MESSAGE.USERNAME_ALREADY_EXISTS);
  }

  // // // Simpan user baru ke database
  // const user = await createUserSvc(validation.value);

  // // Panggil API player (jika diperlukan)
  // await apiPlayerClient.post('/player/store', {
  //   fullName: data.fullName,
  //   username: data.userName,
  //   email: data.email,
  //   phoneNumber: data.phoneNumber,
  //   referredBy: data.referredBy,
  // });

  // return user;

  try {
    // Simpan user baru ke database
    const user = await createUserSvc(validation.value);

    // Panggil API player (jika diperlukan)
    // const res = await apiPlayerClient.post('/player/store', {
    //   fullName: data.fullName,
    //   username: data.userName,
    //   email: data.email,
    //   phoneNumber: data.phoneNumber,
    //   referredBy: data.referredBy,
    // });

    return user;
  } catch (error) {
    logger.error('Error in registerSvc', error);
    throw new CustomException(EXCEPTION_MESSAGE.SERVICE_ERROR, error);
  }
};
