import User, {UserAttributes} from '../../db/models/Users';
import Admin, {AdminAttributes}from '../../db/models/Admin';
import Clien from "../../db/models/Client"

// Template Start

export const getAllUsersRpo = async () => {
  const users = await User.findAll();
  return users.map((user) => user.toJSON());
};

export const getAllAdminsRpo = async () => {
  const admins = await Admin.findAll();
  return admins.map((admin) => admin.toJSON());
}

export const registerUserRpo = async (data: UserAttributes) => {
  // hashing password
}

// Template END

//V1 OLD

export const getAdminByUsername = async (username) => {
  const adminData = await Admin.findOne({ where: { username: username } });
  return adminData;
}

export const getClientById = async(clientId) => {
  const clientCheck = await Clien.findByPk(clientId);
  return clientCheck;
}

export const createAdmin = async (data: AdminAttributes) => {
  return Admin.create(data);
};
