import {Request, Response} from 'express';
import {clientRes} from './client.dto';
import {responseJSON} from '../../helpers/response-handler';

import {signUpSchema, changePassSchema} from './client.validation';
import {getAllClientsSvc, clientSignupSvc, clientPasswordChangeSvc} from './client.service';

export const index = async (req: Request, res: Response) => {
  try {
    const clients = await getAllClientsSvc();
    return responseJSON(req, res, {
      data: clients.map((client) => clientRes(client)),
    });
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};

export const clientSignup = async (req: Request, res: Response) => {
  const validation = signUpSchema.validate(req.body, {
    allowUnknown: true,
  });

  let code = 10009;
  if (validation.error) {
    return responseJSON(
      req,
      res,
      {
        obj: {
          code: 400,
          message: 'Invalid parameter',
        },
      },
      true,
      code,
    );
  }

  try {
    const data = await clientSignupSvc(req.body);

    if ('error' in data) {
      const {message, code} = data.error;
      return responseJSON(
        req,
        res,
        {
          obj: {
            code: 400,
            message: message,
          },
        },
        true,
        code, // Cek Dokumentasi GG halaman terakhir
      );
    }
    return responseJSON(req, res, {data: data});
  } catch (error) {
    return responseJSON(req, res, {message: error.message}, true);
  }
};

export const clientPasswordChange = async (req: Request, res: Response) => {
  const validation = changePassSchema.validate(req.body, {
    allowUnknown: true,
  });

  if (validation.error) {
    return responseJSON(
      req,
      res,
      {
        obj: {
          code: 400,
          message: 'Invalid parameter',
        },
      },
      true,
    );
  }

  try {
    const data = await clientPasswordChangeSvc(req.body);

    if ('error' in data) {
      const {message, code} = data.error;
      return responseJSON(
        req,
        res,
        {
          obj: {
            code: 400,
            message: message,
          },
        },
        true,
        code, // Cek Dokumentasi GG halaman terakhir
      );
    }
    return responseJSON(req, res, {data: data});
  } catch (error) {
    return responseJSON(req, res, {message: error.message}, true);
  }
};
