import Client, {ClientInstance} from '../../db/models/Client';
import Partner, {PartnerInstance} from '../../db/models/Partner';
import Admin, {AdminInstance} from '../../db/models/Admin';

import CollectionBucketBounce from '../../db/models/game/Bounce/collectionBucket';
import CollectionBucketBounceAztec from '../../db/models/game/BounceAztec/collectionBucket';
import CollectionBucketBounceSpace from '../../db/models/game/BounceSpace/collectionBucket';

import CollectionBucketMonopoly from '../../db/models/game/Monopoly/collectionBucket';
import CollectionBucketCityMonopoly from '../../db/models/game/MonopolyCity/collectionBucket';
import CollectionBucketSnakeMonopoly from '../../db/models/game/MonopolySnake/collectionBucket';

import CollectionBucketCrash from '../../db/models/game/Crash/collectionBucket';
import CollectionBucketIronCrash from '../../db/models/game/CrashIron/collectionBucket';
import CollectionBucketWukongCrash from '../../db/models/game/CrashWukong/collectionBucket';

import CollectionBucketHeist from '../../db/models/game/Heist/collectionBucket';
import CollectionBucketRoyaleHeist from '../../db/models/game/HeistRoyale/collectionBucket';

import CollectionBucketMines from '../../db/models/game/Mines/collectionBucket';
import CollectionBucketDiggerMines from '../../db/models/game/MinesDigger/collectionBucket';

import CollectionBucketPlinko from '../../db/models/game/Plinko/collectionBucket';
import CollectionBucketLiongPlinko from '../../db/models/game/PlinkoLiong/collectionBucket';
import CollectionBucketOlympusPlinko from '../../db/models/game/PlinkoOlympus/collectionBucket';

export const getAllClientsRpo = async () => {
  const clients = await Client.findAll();
  return clients.map((client) => client.toJSON());
};

export const findClientById = (id: number): Promise<ClientInstance | null> => {
  return Client.findByPk(id);
};

export const createClient = (data: any) => {
  return Client.create(data);
};

export const findPartnerByName = (
  name: string,
): Promise<PartnerInstance | null> => {
  return Partner.findOne({where: {name}});
};

export const findAdminByUsername = (
  username: string,
): Promise<AdminInstance | null> => {
  return Admin.findOne({where: {username}});
};

export const updateAdminPassword = async (
  adminInstance: any,
  hashedPassword: string,
) => {
  adminInstance.password = hashedPassword;
  return adminInstance.save();
};

export const createAllBuckets = async (
  clientId: string,
  currency: string,
  max: number,
) => {
  const baseData = {
    total_max: max,
    current: 0,
    total_shared: 0,
    total_cycle: 0,
    rtp: 95,
    current_gap: 0,
    total_return: 0,
    total_bet: 0,
    client_id: clientId,
    currency,
    total_result: 0,
  };

  const dated = {
    create_date: new Date(),
    update_date: new Date(),
    last_reset: new Date(),
  };

  const crashData = {
    is_loss: 0,
    is_jackpot: false,
  };

  const heistData = {
    current_rtp: 0,
  };

  const minesData = {
    current_rtp: 0,
  };

  const monopolyData = {
    current_rtp: 0,
    is_jackpot: false,
  };

  const bounceData = {
    current_rtp: 0,
    is_jackpot: false,
  };

  await Promise.all([
    // Plinko
    CollectionBucketPlinko.create(baseData),
    CollectionBucketLiongPlinko.create(baseData),
    CollectionBucketOlympusPlinko.create(baseData),

    // Crash
    CollectionBucketCrash.create({...baseData, ...dated, ...crashData}),
    CollectionBucketIronCrash.create({
      ...baseData,
      ...dated,
      ...crashData,
    }),
    CollectionBucketWukongCrash.create({
      ...baseData,
      ...dated,
      ...crashData,
    }),

    // Heist
    CollectionBucketHeist.create({...baseData, ...dated, ...heistData}),
    CollectionBucketRoyaleHeist.create({...baseData, ...dated, ...heistData}),

    // Mines
    CollectionBucketMines.create({...baseData, ...dated, ...minesData}),
    CollectionBucketDiggerMines.create({...baseData, ...dated, ...minesData}),

    // Monopoly
    CollectionBucketMonopoly.create({
      ...baseData,
      ...dated,
      ...monopolyData,
    }),
    CollectionBucketSnakeMonopoly.create({
      ...baseData,
      ...dated,
      ...monopolyData,
    }),
    CollectionBucketCityMonopoly.create({
      ...baseData,
      ...dated,
      ...monopolyData,
    }),

    //Bounce
    CollectionBucketBounceAztec.create({...baseData, ...dated, ...bounceData}),
    CollectionBucketBounceSpace.create({...baseData, ...dated, ...bounceData}),
    CollectionBucketBounce.create({...baseData, ...dated, ...bounceData}),
  ]);
};
