import {Router} from 'express';
import {index, clientSignup, clientPasswordChange} from './client.controller';

import {verifyAdminToken} from '../../middleware/middlewareNew';

const clientRouter = Router();

clientRouter.get('/', verifyAdminToken, index);
clientRouter.post('/clientSignup', verifyAdminToken, clientSignup);
clientRouter.post('/clientPasswordChange', verifyAdminToken, clientPasswordChange);

export default clientRouter;
