import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllCurrenciesSvc,
} from './currency.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {currencyRes} from './currency.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const currencies = await getAllCurrenciesSvc();
    return responseJSON(req, res, {data: currencies.map((currency) => currencyRes(currency))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
