import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getAllDomainsSvc,
} from './domainList.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {domainListRes} from './domainList.dto';

export const index = async (req: Request, res: Response) => {
  try {
    const domainLists = await getAllDomainsSvc();
    return responseJSON(req, res, {data: domainLists.map((domainList) => domainListRes(domainList))});
  } catch (err) {
    return responseJSON(req, res, {message: err.message}, true);
  }
};
