import {
  getAllGameListsRpo,
  getGameListByIdsRpo
} from './gameList.repository';
import {gameListRes} from './gameList.dto';

export const getAllGameListsSvc = async (filters: {
  name?: string;
  pagination?: boolean;
  page?: number;
  limit?: number;
}) => {
  try {
    return await getAllGameListsRpo(filters);
  } catch (err) {
    console.error('getAllGameListsSvc error:', err);
    throw new Error('Service failed to get game list data.');
  }
};


export const getGameListByIdSvc = async (id: number) => {
  const game = await getGameListByIdsRpo(id);
  return game ? gameListRes(game) : null;
};