import {Request, Response} from 'express';
import * as Joi from 'joi';
import {
  getWinAndLoseReportsSvc,
  getDropdownsSvc,
  getWinAndLoseByFiltersSvc,
  getWinAndLoseGamesSvc
} from './home.service';
import {responseJSON} from '../../helpers/response-handler';
import {CustomException} from '../../exceptions/CustomException';
import {EXCEPTION_MESSAGE} from '../../exceptions/EXCEPTION_MESSAGE';
import {isValidPositiveInt} from '../../utils/validators';

export interface AuthenticatedRequest extends Request {
  user?: any;
  id?: string;
  roleId?: string;
}

// export const dailyReport = async (req: Request, res: Response) => {
//   try {
//     const {
//       start_time,
//       end_time,
//       name,
//       currency,
//       page = '1',
//       limit = '10',
//     } = req.query;

//     const filters = {
//       start_time: start_time ? new Date(start_time as string) : undefined,
//       end_time: end_time ? new Date(end_time as string) : undefined,
//       name,
//       currency,
//       page: parseInt(page as string, 10),
//       limit: parseInt(limit as string, 10),
//     };
//     console.log('filters', filters);
//     return filters;
//     const {results, total} = await getDailyReportsSvc(filters);

//     return res.status(200).json({
//       status: 'success',
//       message: 'SUCCESS',
//       total,
//       page: filters.page,
//       limit: filters.limit,
//       data: results,
//     });
//   } catch (error) {
//     console.error('Error executing dailyReport:', error);
//     return res.status(500).json({
//       status: 'error',
//       message: 'Internal server error',
//     });
//   }
// };

export const winAndLoseReport = async (req: Request, res: Response) => {
  try {
    const app_id = req.query.app_id ?? null;
    const currency = req.query.currency?.toString().trim() || 'idr';

    const results = await getWinAndLoseReportsSvc(app_id,currency);

    return res.status(200).json({
      msg: 'success',
      data: results,
    });
  } catch (error) {
    console.error('Error executing query:', error);
    return res.status(500).json({code: '0', msg: 'Internal server error'});
  }
};

  
export const dropdownCurrency = async (req: AuthenticatedRequest, res: Response) => {
  try {
    const roleId = req.roleId; // Ambil dari middleware jwt

    const data = await getDropdownsSvc({ roleId }); // Kirim ke service

    return res.status(200).json({
      msg: 'success',
      data,
    });
  } catch (error: any) {
    console.error('Error fetching currencies:', error.message);
    return res.status(500).json({ msg: 'Internal server error' });
  }
};

export const dropdownPartner = async (req: AuthenticatedRequest, res: Response) => {
  try {
    const roleId = req.roleId; // Ambil dari middleware jwt

    const data = await getDropdownsSvc({ roleId }); // Kirim ke service

    return res.status(200).json({
      msg: 'success',
      data,
    });
  } catch (error: any) {
    console.error('Error fetching currencies:', error.message);
    return res.status(500).json({ msg: 'Internal server error' });
  }
};


export const winAndLoseByFilter = async (req: Request, res: Response) => {
  try {

    const filter_by = req.body.filter_by?.toString().trim() || 'monthly';
    const partnerId = req.body.partnerId ?? null;
    const currency = req.body.currency?.toString().trim() || 'idr';
    console.log('filter_by', filter_by)
    console.log('partnerId', partnerId)
    console.log('currency', currency)

    const results = await getWinAndLoseByFiltersSvc(partnerId, currency, filter_by);

    return res.status(200).json({
      msg: 'success',
      data: results,
    });
  } catch (error) {
    console.error('Error executing query:', error);
    return res.status(500).json({code: '0', msg: 'Internal server error'});
  }
};


export const winAndLoseGame = async (req: Request, res: Response) => {
  try {

    // const partnerId = req.body.partnerId ?? null;
    // const currency = req.body.currency?.toString().trim() || 'idr';
    const partnerId = req.query.partnerId ?? null;
    const currency = req.query.currency?.toString().trim() || 'idr';
    console.log('partnerId', partnerId)
    console.log('currency', currency)

    const results = await getWinAndLoseGamesSvc(partnerId, currency);

    return res.status(200).json({
      msg: 'success',
      data: results,
    });
  } catch (error) {
    console.error('Error executing query:', error);
    return res.status(500).json({code: '0', msg: 'Internal server error'});
  }
};


