import {Router} from 'express';
import {winAndLoseReport, dropdownCurrency, dropdownPartner, winAndLoseByFilter, winAndLoseGame} from './home.controller';
import { verifyAdminToken} from '../../middleware/middlewareNew'
import { validatePositiveInts } from '../../middleware/validatePositiveId';
import { authenticateToken } from '../../middleware/jwt';

const reportRouter = Router();

reportRouter.get('/get-win-lose', authenticateToken, validatePositiveInts(['page', 'limit']), winAndLoseReport);
reportRouter.get('/dropdown-currencies', authenticateToken, dropdownCurrency);
reportRouter.get('/dropdown-partner', authenticateToken, dropdownPartner);
reportRouter.post('/get-win-lose-report', authenticateToken, winAndLoseByFilter);
reportRouter.get('/get-win-lose-game-report', authenticateToken, winAndLoseGame);

export default reportRouter;
